/*
 * Decompiled with CFR 0.152.
 */
package panther.pep;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import panther.pep.VerifyProgressImpl;
import panther.util.general.Constants;
import panther.util.general.ProportionalBox;
import panther.util.general.ProportionalLayoutManager;
import panther.util.general.RandomUtils;
import panther.util.smalltalk.SimpleBlock;
import panther.util.unicon.GuaranteedActionStrict;
import panther.xp.XPass;
import pse.pt.PacketTracer;
import pse.pt.PacketTracerUtils;
import pse.util.general.ApplicationError;
import pse.util.general.Utilities;
import pse.util.general.VerifyProgress;
import skeletonapplet.AbstractDelegatorApplet;
import skeletonapplet.AppletWorker;
import skeletonapplet.JreInfo;
import skeletonapplet.PacketTracerLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExamWarningWorker
implements AppletWorker {
    protected AbstractDelegatorApplet applet;
    protected Thread packetTracerWork;
    protected JProgressBar progressBar;
    protected JButton startAssessmentButton;
    protected PacketTracer packetTracer;
    protected XPass xpass;
    protected boolean canStartAssessment = true;
    protected String ptaAuthentication;
    protected String ptaLocation;
    protected String[] allowedPtVersions;
    protected String[] disallowedPtVersions;
    protected boolean isContinued;
    protected String minimumPtVersionSpecific;
    protected VerifyProgress verifyProgress;
    protected int maximumPacketTracerVersionCheckTimeInSeconds = 8;
    protected String myId;

    public ExamWarningWorker() {
        JreInfo.soleInstance().ptaBuild().setValueOkay("12.009");
    }

    @Override
    public void setApplet(AbstractDelegatorApplet abstractDelegatorApplet) {
        this.applet = abstractDelegatorApplet;
    }

    @Override
    public String getBuildVersion() {
        return "12.009";
    }

    @Override
    public Date getLoadDate() {
        return Constants.LOAD_DATE;
    }

    @Override
    public void instanceCreation() {
        this.progressBar = new JProgressBar(0);
        this.startAssessmentButton = new JButton("Start Assessment");
        this.startAssessmentButton.addActionListener(this);
        this.startAssessmentButton.setBorder(BorderFactory.createBevelBorder(0));
        this.startAssessmentButton.setEnabled(false);
        this.applet.setLayout(new ProportionalLayoutManager());
        this.applet.add((Component)this.progressBar, new ProportionalBox(5, 2, 90, 47));
        this.applet.add((Component)this.startAssessmentButton, new ProportionalBox(25, 51, 50, 47));
        this.applet.setVisible(false);
    }

    @Override
    public void init() {
        this.myId = String.valueOf(this.hashCode()) + RandomUtils.chooseInt(1001, 9999);
        try {
            String string;
            Object object;
            String string2 = this.getParameter("backgroundcolor");
            if (string2 != null && string2.length() > 0) {
                try {
                    object = new Color(Integer.parseInt(string2, 16));
                    this.applet.setBackground((Color)object);
                    this.applet.getContentPane().setBackground((Color)object);
                    this.progressBar.setBackground(this.applet.getBackground());
                    this.startAssessmentButton.setBackground(Color.LIGHT_GRAY);
                }
                catch (Throwable throwable) {
                    Utilities.checkIgnore(throwable);
                }
            }
            if ((object = this.getParameter("maxptverchecktime")) != null && ((String)object).trim().length() > 0) {
                try {
                    this.maximumPacketTracerVersionCheckTimeInSeconds = Integer.parseInt((String)object);
                }
                catch (Throwable throwable) {
                    Utilities.checkIgnore(throwable);
                }
            }
            try {
                string = this.getParameter("allowedptversions", "5.2.0.007;5.2.0.008;5.2.0.009;5.2.0.01;5.2.1;5.3");
                this.allowedPtVersions = string.split(";");
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
                this.allowedPtVersions = Constants.ALLOWED_PT_VERSIONS;
            }
            try {
                string = this.getParameter("disallowedptversions", "");
                this.disallowedPtVersions = string == null || string.trim().length() == 0 ? new String[0] : string.split(";");
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
                this.disallowedPtVersions = Constants.DISALLOWED_PT_VERSIONS;
            }
            try {
                string = this.getParameter("iscontinued", "false");
                this.isContinued = Boolean.parseBoolean(string);
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
                this.isContinued = false;
            }
            this.minimumPtVersionSpecific = this.getParameter("minimumptversionspecific", Constants.MINIMUM_PT_VERSION_SPECIFIC_PARAMETER_DEFAULT);
            this.ptaLocation = this.getParameter("ptaplayerlocation", "extensions/ptaplayer");
            this.ptaAuthentication = this.getParameter("ptaplayerauthentication", "ptaplayer.pta");
            this.applet.setVisible(true);
            this.startAssessmentButton.setVisible(true);
            this.progressBar.setVisible(true);
            this.packetTracerWork = new Thread(){

                public void run() {
                    ExamWarningWorker.this.launchPacketTracer();
                }
            };
            this.packetTracerWork.start();
        }
        catch (Throwable throwable) {
            this.handleTopLevelThrowable(throwable);
        }
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void performComplete() {
    }

    @Override
    public void performInterrupt() {
    }

    @Override
    public void performQuit() {
    }

    @Override
    public void start() {
        try {
            this.startAssessmentButton.paintImmediately(this.startAssessmentButton.getVisibleRect());
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
        }
        try {
            this.progressBar.paintImmediately(this.progressBar.getVisibleRect());
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            this.startAssessmentButton.setEnabled(false);
            this.applet.getAppletContext().showDocument(this.xpass.getExamURL());
        }
        catch (Throwable throwable) {
            this.handleTopLevelThrowable(throwable);
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public void destroy() {
        this.closePacketTracer();
    }

    protected void handleTopLevelThrowable(Throwable throwable) {
        this.canStartAssessment = false;
        try {
            Utilities.checkSwallow(throwable);
        }
        catch (Throwable throwable2) {
            skeletonapplet.Utilities.logPrintln("Error in checkSwallow: " + throwable2);
            Utilities.check(throwable2);
        }
        String string = "";
        HashMap<String, String> hashMap = null;
        if (throwable instanceof ApplicationError.HigherMinimumPtVersionError) {
            string = "higherptversion";
            ApplicationError.HigherMinimumPtVersionError higherMinimumPtVersionError = (ApplicationError.HigherMinimumPtVersionError)throwable;
            hashMap = new HashMap<String, String>();
            hashMap.put("currentptversion", higherMinimumPtVersionError.getCurrentPtVersion());
            hashMap.put("requiredptversion", higherMinimumPtVersionError.getRequiredPtVersion());
        } else if (throwable instanceof ApplicationError.IpcError) {
            string = "ipcerror";
        } else if (throwable instanceof ApplicationError.NoIpcPort) {
            string = "noipcport";
        } else if (throwable instanceof ApplicationError.PacketTracerConnectTimeOut) {
            string = "ptconnecttimeout";
        } else if (throwable instanceof ApplicationError.PacketTracerLaunch) {
            string = "ptlaunch";
        } else if (throwable instanceof ApplicationError.ParameterProcessing) {
            string = "parameterprocessing";
        } else if (throwable instanceof ApplicationError.PacketTracerVersionProblem) {
            string = "ptversionproblem";
        } else if (throwable instanceof ApplicationError.PacketTracerVersionReducedError) {
            string = "ptversionreducedsinceautosave";
            ApplicationError.PacketTracerVersionReducedError packetTracerVersionReducedError = (ApplicationError.PacketTracerVersionReducedError)throwable;
            hashMap = new HashMap();
            hashMap.put("currentptversion", packetTracerVersionReducedError.getCurrentPtVersion());
            hashMap.put("requiredptversion", packetTracerVersionReducedError.getRequiredPtVersion());
        } else {
            string = "unknownjavaerror";
        }
        this.simpleError(string, throwable, hashMap);
    }

    protected void launchPacketTracer() {
        try {
            this.verifyProgress = new VerifyProgressImpl(this.progressBar);
            this.verifyProgress.begin();
            this.progressBar.setVisible(true);
            this.verifyProgress.startPreparation();
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    ExamWarningWorker.this.applet.repaint();
                }
            });
            this.xpass = new XPass(this.myId);
            this.xpass.initialize(this.applet, this.getParameter("message"));
            this.verifyProgress.finishPreparation();
            this.verifyProgress.startFindPacketTracer();
            if (!this.checkForPacketTracer()) {
                this.noPacketTracer();
                return;
            }
            this.verifyProgress.finishFindPacketTracer();
            this.verifyProgress.startFindPtaFile();
            if (!this.checkPtaFile()) {
                this.ptaMissing(this.ptaAuthentication, this.ptaLocation);
                return;
            }
            this.verifyProgress.finishFindPtaFile();
            this.verifyProgress.startFindIpcPort();
            int n = PacketTracer.findOpenIpcPort(39500);
            this.verifyProgress.finishFindIpcPort();
            if (n <= 0) {
                throw new ApplicationError.NoIpcPort();
            }
            this.packetTracer = new PacketTracer("localhost", n, true);
            this.verifyProgress.startLaunchPacketTracer();
            this.packetTracer.launch(this.applet.getLocator());
            this.verifyProgress.finishLaunchPacketTracer();
            this.verifyProgress.startConnectPacketTracer();
            this.packetTracer.connect();
            this.verifyProgress.finishConnectPacketTracer();
            this.verifyProgress.startCheckPacketTracerVersion();
            this.checkPacketTracerVersion();
            this.verifyProgress.finishCheckPacketTracerVersion();
            this.verifyProgress.startClosePacketTracer();
            this.closePacketTracer();
            this.verifyProgress.finishClosePacketTracer();
            this.verifyProgress.end();
            this.progressBar.setVisible(false);
            Utilities.guaranteedSleep(1000L);
            if (this.canStartAssessment) {
                this.startAssessmentButton.setEnabled(true);
            }
        }
        catch (Throwable throwable) {
            this.handleTopLevelThrowable(throwable);
        }
    }

    protected boolean checkForPacketTracer() {
        try {
            PacketTracerLocator packetTracerLocator = this.applet.getLocator();
            return packetTracerLocator != null && packetTracerLocator.executableExists();
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
            return false;
        }
    }

    protected boolean checkPtaFile() {
        try {
            PacketTracerLocator packetTracerLocator = this.applet.getLocator();
            if (packetTracerLocator == null) {
                return false;
            }
            File file = packetTracerLocator.getHomeDirectory();
            if (file == null) {
                return false;
            }
            File file2 = new File(file, this.ptaLocation);
            if (file2 == null || !file2.exists() || !file2.isDirectory()) {
                return false;
            }
            File file3 = new File(file2, this.ptaAuthentication);
            return file3 != null && file3.exists();
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
            return false;
        }
    }

    protected void checkPacketTracerVersion() {
        int n;
        int n2;
        SimpleBlock simpleBlock = new SimpleBlock(){

            public Object evaluate() throws Exception {
                return ExamWarningWorker.this.packetTracer.getVersion();
            }
        };
        GuaranteedActionStrict guaranteedActionStrict = new GuaranteedActionStrict("get packet tracer version", this.maximumPacketTracerVersionCheckTimeInSeconds * 1000, simpleBlock, true);
        guaranteedActionStrict.run();
        if (guaranteedActionStrict.timedOut()) {
            throw new ApplicationError.PacketTracerConnectTimeOut();
        }
        if (!guaranteedActionStrict.isSuccessful()) {
            throw new ApplicationError.PacketTracerVersionProblem();
        }
        String string = (String)guaranteedActionStrict.getReturnValue();
        if (string == null) {
            throw new ApplicationError.PacketTracerVersionProblem();
        }
        JreInfo.soleInstance().ptVersion().setValue(string);
        skeletonapplet.Utilities.logPrintln("\n\nPT Version = <" + string + ">\n");
        for (n2 = 0; n2 < this.disallowedPtVersions.length; ++n2) {
            if (!string.startsWith(this.disallowedPtVersions[n2])) continue;
            throw new ApplicationError.PacketTracerVersionProblem();
        }
        n2 = 1;
        for (n = 0; n < this.allowedPtVersions.length; ++n) {
            if (!string.startsWith(this.allowedPtVersions[n])) continue;
            n2 = 0;
        }
        if (n2 != 0) {
            throw new ApplicationError.PacketTracerVersionProblem();
        }
        if (this.minimumPtVersionSpecific != null && this.minimumPtVersionSpecific.trim().length() > 0) {
            n = 0;
            if (PacketTracerUtils.getMajorVersion(string) < PacketTracerUtils.getMajorVersion(this.minimumPtVersionSpecific)) {
                n = 1;
            } else if (PacketTracerUtils.getMajorVersion(string) == PacketTracerUtils.getMajorVersion(this.minimumPtVersionSpecific)) {
                if (PacketTracerUtils.getMinorVersion(string) < PacketTracerUtils.getMinorVersion(this.minimumPtVersionSpecific)) {
                    n = 1;
                } else if (PacketTracerUtils.getMinorVersion(string) == PacketTracerUtils.getMinorVersion(this.minimumPtVersionSpecific) && PacketTracerUtils.getPatchVersion(string) < PacketTracerUtils.getPatchVersion(this.minimumPtVersionSpecific)) {
                    n = 1;
                }
            }
            if (n != 0) {
                if (this.isContinued) {
                    throw new ApplicationError.PacketTracerVersionReducedError(string, this.minimumPtVersionSpecific);
                }
                throw new ApplicationError.HigherMinimumPtVersionError(string, this.minimumPtVersionSpecific);
            }
        }
    }

    protected void closePacketTracer() {
        if (this.packetTracer != null) {
            try {
                this.packetTracer.shutDown();
            }
            catch (Throwable throwable) {
                Utilities.checkSwallow(throwable);
            }
            this.packetTracer = null;
            Utilities.guaranteedSleep(3000L);
        }
    }

    protected String getParameter(String string) {
        return this.applet.getParameter(string);
    }

    protected String getParameter(String string, String string2) {
        String string3 = this.getParameter(string);
        return string3 == null ? string2 : string3;
    }

    protected void noPacketTracer() {
        if (this.verifyProgress != null) {
            this.verifyProgress.end();
        }
        this.progressBar.setVisible(false);
        this.closePacketTracer();
        try {
            this.applet.getAppletContext().showDocument(this.xpass.getNoPacketTracerURL());
        }
        catch (Throwable throwable) {
            Utilities.check(throwable);
            throw new Error("Unable to continue processing; no way to report error: No Packet Tracer.\nMessage ID: AP-EW-003", throwable);
        }
    }

    protected void ptaMissing(String string, String string2) {
        if (this.verifyProgress != null) {
            this.verifyProgress.end();
        }
        this.progressBar.setVisible(false);
        this.closePacketTracer();
        try {
            this.applet.getAppletContext().showDocument(this.xpass.getPtaMissingURL(string, string2));
        }
        catch (Throwable throwable) {
            Utilities.check(throwable);
            throw new Error("Unable to continue processing; no way to report error: PTA Missing.\nMessage ID: AP-EW-001", throwable);
        }
    }

    protected void simpleError(String string, Throwable throwable) {
        this.simpleError(string, throwable, null);
    }

    protected void simpleError(String string, Throwable throwable, Map<String, String> map) {
        if (this.verifyProgress != null) {
            this.verifyProgress.end();
        }
        this.progressBar.setVisible(false);
        this.closePacketTracer();
        try {
            this.xpass.reportGeneralError(this.applet.getDocumentBase(), string, throwable, map);
        }
        catch (Throwable throwable2) {
            Utilities.check(throwable2);
        }
        try {
            this.applet.getAppletContext().showDocument(this.xpass.getGeneralErrorURL(this.applet.getDocumentBase(), string, throwable, map));
        }
        catch (Throwable throwable3) {
            Utilities.check(throwable3);
            throw new Error("Unable to continue processing; no way to report error: " + string + ".\nMessage ID: AP-EW-002", throwable3);
        }
    }
}

